"""Simple program to demo how to use meshtastic library.
   To run: python examples/info.py
"""

import meshtastic
import meshtastic.serial_interface
import json
import base64



ports = meshtastic.util.findPorts(True)
#print(f"ports:{ports}")
#print(f"ports:{ports.vid}")
if len(ports) == 0:
    print("No Serial Meshtastic device detected, attempting TCP connection on localhost.")
elif len(ports) > 1:
    message = "Warning: Multiple serial ports were detected so one serial port must be specified with the '--port'.\n"
    message += f"  Ports detected:{ports}"


for port in ports:
    print(port)

interface = meshtastic.serial_interface.SerialInterface(ports[0])


# call showInfo() just to ensure values are populated
print(interface.myInfo)
print(interface.metadata)
#print(json.dumps(interface.nodesByNum, indent=2))
#interface = meshtastic.serial_interface.SerialInterface()
interface.close()
